/*
 * Decompiled with CFR 0.152.
 */
package com.zkryle.jeg.client.golem.models;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import com.zkryle.jeg.common.golem.MagmaticGolemEntity;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;

public class MagmaticGolemModel<T extends MagmaticGolemEntity>
extends EntityModel<T>
implements ArmedModel {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("justenoughgolems", "magmatic_golem"), "magmatic_golem");
    private final ModelPart wholebody;

    public MagmaticGolemModel(ModelPart root) {
        this.wholebody = root.getChild("wholebody");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition wholebody = partdefinition.addOrReplaceChild("wholebody", CubeListBuilder.create(), PartPose.offsetAndRotation((float)-0.5f, (float)18.0f, (float)0.0f, (float)-3.1416f, (float)0.0f, (float)3.1416f));
        PartDefinition neck = wholebody.addOrReplaceChild("neck", CubeListBuilder.create().texOffs(0, 20).addBox(-1.6f, -1.0f, -1.6f, 3.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-0.1f, (float)-2.0f, (float)0.0f));
        PartDefinition arm1 = wholebody.addOrReplaceChild("arm1", CubeListBuilder.create().texOffs(16, 24).addBox(-2.0f, 0.0f, -1.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-3.5f, (float)-1.0f, (float)0.0f));
        PartDefinition arm2 = wholebody.addOrReplaceChild("arm2", CubeListBuilder.create().texOffs(24, 24).addBox(0.0f, 0.0f, -1.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.5f, (float)-1.0f, (float)0.0f));
        PartDefinition leg1 = wholebody.addOrReplaceChild("leg1", CubeListBuilder.create().texOffs(8, 24).addBox(-1.0f, 0.0f, -1.1f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-1.5f, (float)4.0f, (float)0.0f));
        PartDefinition leg2 = wholebody.addOrReplaceChild("leg2", CubeListBuilder.create().texOffs(8, 28).addBox(-1.0f, 0.0f, -0.9f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)1.5f, (float)4.0f, (float)0.0f));
        PartDefinition stomach = wholebody.addOrReplaceChild("stomach", CubeListBuilder.create().texOffs(0, 8).addBox(-3.1f, 0.0f, -1.25f, 6.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(6, 0).addBox(-4.1f, -3.0f, -2.25f, 8.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.1f, (float)1.0f, (float)0.0f));
        PartDefinition wholehead = wholebody.addOrReplaceChild("wholehead", CubeListBuilder.create(), PartPose.offset((float)-0.1f, (float)-2.4f, (float)0.0f));
        PartDefinition head = wholehead.addOrReplaceChild("head", CubeListBuilder.create().texOffs(12, 15).addBox(-2.3f, -4.0f, -2.6f, 5.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(0, 28).addBox(-0.3f, -2.0f, 2.0f, 1.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-0.1f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r1 = head.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(0, 16).addBox(-2.5f, -7.5f, 0.0f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.1309f));
        PartDefinition cube_r2 = head.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(0, 16).addBox(-0.25f, -6.25f, 0.0f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.48f));
        PartDefinition cube_r3 = head.addOrReplaceChild("cube_r3", CubeListBuilder.create().texOffs(0, 16).addBox(-0.5f, -6.0f, 0.0f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.48f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        boolean flag = entity.func_184599_cB() > 4;
        boolean isOn = ((MagmaticGolemEntity)((Object)entity)).isOn();
        this.wholebody.getChild((String)"wholehead").xRot = ((MagmaticGolemEntity)((Object)entity)).headInclination >= 0.0f ? headPitch * ((float)(-Math.PI) / 180) : ((MagmaticGolemEntity)((Object)entity)).headInclination;
        this.wholebody.getChild((String)"wholehead").yRot = netHeadYaw * ((float)Math.PI / 180);
        this.wholebody.getChild((String)"leg1").xRot = isOn ? Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount : 0.0f;
        this.wholebody.getChild((String)"leg2").xRot = isOn ? Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount : 0.0f;
        float f = 1.0f;
        if (flag) {
            f = (float)entity.getDeltaMovement().lengthSqr();
            f /= 0.2f;
            f = f * f * f;
        }
        if (f < 1.0f) {
            f = 1.0f;
        }
        this.wholebody.getChild((String)"arm2").xRot = isOn ? Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 2.0f * limbSwingAmount * 0.5f / -f : 0.0f;
        this.wholebody.getChild((String)"arm1").xRot = isOn ? Mth.cos((float)(limbSwing * 0.6662f)) * 2.0f * limbSwingAmount * 0.5f / -f : 0.0f;
        this.wholebody.getChild((String)"arm2").zRot = 0.0f;
        this.wholebody.getChild((String)"arm1").zRot = 0.0f;
        if (!entity.getMainHandItem().isEmpty()) {
            this.wholebody.getChild((String)"arm2").xRot = this.wholebody.getChild((String)"arm2").xRot * 0.5f + 0.31415927f;
        }
        this.setupAttackAnimation(entity, ageInTicks);
    }

    public void translateToHand(HumanoidArm pSide, PoseStack pMatrixStack) {
        pMatrixStack.scale(0.5f, 0.5f, 0.5f);
        pMatrixStack.translate(-0.35, 2.3, 0.05);
        pMatrixStack.mulPose(Vector3f.YP.rotationDegrees(180.0f));
        this.wholebody.getChild("arm2").translateAndRotate(pMatrixStack);
        pMatrixStack.mulPose(Vector3f.YN.rotationDegrees(180.0f));
        pMatrixStack.mulPose(Vector3f.XN.rotationDegrees(5.0f));
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        poseStack.scale(1.5f, 1.5f, 1.5f);
        poseStack.translate((double)0.025f, -0.5, 0.0);
        this.wholebody.render(poseStack, buffer, packedLight, packedOverlay);
    }

    protected void setupAttackAnimation(T p_230486_1_, float p_230486_2_) {
        if (!(this.attackTime <= 0.0f)) {
            float f = 1.0f - this.attackTime;
            f *= f;
            f *= f;
            f = 1.0f - f;
            float f1 = Mth.sin((float)(f * (float)Math.PI));
            float f2 = Mth.sin((float)(this.attackTime * (float)Math.PI)) * -(this.wholebody.getChild((String)"wholehead").xRot - 0.7f) * 0.75f;
            this.wholebody.getChild((String)"arm2").xRot = (float)((double)this.wholebody.getChild((String)"arm2").xRot + ((double)f1 * 1.2 + (double)f2));
            this.wholebody.getChild((String)"arm2").zRot += Mth.sin((float)(this.attackTime * (float)Math.PI)) * 0.4f;
        }
    }

    public void copyPropertiesTo(EntityModel<T> p_217111_1_) {
        p_217111_1_.attackTime = this.attackTime;
        p_217111_1_.riding = this.riding;
        p_217111_1_.young = this.young;
        super.copyPropertiesTo(p_217111_1_);
    }
}

